"use client"

import { Button } from "@/components/ui/button";
import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { cn } from "@/lib/utils";
import { TransformedAgency } from "@/types/transformers";
import { ComponentWithClassName } from "@/types/utils";
import { BadgeInfo } from "lucide-react";

export function WorkflowButtonView({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedAgency> }>) {
  const { setWorkflow } = useApplicationWorkflow()

  return (
    <Button
      variant="outline"
      size={"sm"}
      onClick={() => setWorkflow({
        __tag: "VIEW_AGENCY_FEED",
        id: data.gtfsId,
      })}
      className={cn(
        className
      )}
      aria-label={`Open dialog to view details for agency ${data.name}.`}
    >
      <BadgeInfo className="size-3" />
    </Button>
  )
}

